﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RimWorld;
using Verse;

namespace ArkhamEstate
{
    class UtilityWorldObject_ArkhamEstate : Cthulhu.UtilityWorldObject
    {
        private bool CheckedForRecipes = false;
        private bool AreRecipesReady = false;

        public override void Tick()
        {
            base.Tick();

            //Log.Message("UtilityWorldObject Arkham Estate Started");
            if (!CheckedForRecipes)
            {
                GenerateStrangeMeatRecipe();
                CheckedForRecipes = true;
            }
        }


        public void GenerateStrangeMeatRecipe()
        {
            if (Cthulhu.Utility.IsCosmicHorrorsLoaded() && !AreRecipesReady)
            {
                foreach (RecipeDef current in DefDatabase<RecipeDef>.AllDefs)
                {
                    if (current.defName.Contains("Jecrell_MakeWax"))
                    {
                        Log.Message("Found MakeWax");
                        //CosmicHorror_StrangeMeatRaw

                        ThingFilter newFilter = new ThingFilter();
                        newFilter.CopyAllowancesFrom(current.fixedIngredientFilter);
                        newFilter.SetAllow(ThingCategoryDef.Named("CosmicHorror_StrangeMeatRaw"), true);
                        current.fixedIngredientFilter = newFilter;


                        ThingFilter newFilter2 = new ThingFilter();
                        newFilter2.CopyAllowancesFrom(current.defaultIngredientFilter);
                        newFilter2.SetAllow(ThingCategoryDef.Named("CosmicHorror_StrangeMeatRaw"), true);
                        current.defaultIngredientFilter = newFilter;

                        foreach (IngredientCount temp in current.ingredients)
                        {
                            if (temp.filter != null)
                            {
                                ThingFilter newFilter3 = new ThingFilter();
                                newFilter3.CopyAllowancesFrom(temp.filter);
                                newFilter3.SetAllow(ThingCategoryDef.Named("CosmicHorror_StrangeMeatRaw"), true);
                                temp.filter = newFilter3;
                                Log.Message("Added new filter");
                            }
                        }
                    }
                }
                AreRecipesReady = true;
                Log.Message("Strange meat added to wax recipes.");
            }
            return;
        }

        public override void ExposeData()
        {
            //Scribe_Collections.LookList<CosmicEntity>(ref this.DeityCache, "Deities", LookMode.Deep, new object[0]);
            //Scribe_Values.LookValue<bool>(ref this.AreRecipesReady, "AreRecipesReady", false, false);
            base.ExposeData();
            if (Scribe.mode == LoadSaveMode.PostLoadInit)
            {
                GenerateStrangeMeatRecipe();
            }
        }

    }
}
